#include "q3la.h"

char td_string[256] = "<td>";

void html::html_header(outputfile* out)
{
	out->write ("<html>\r\n");
	out->write ("<center>\r\n");
	out->write ("<body bgcolor=\"#000000\" text=\"#FFFFFF\">\r\n");
	out->write ("<font face=\"Arial\">\r\n");
}

void html::html_footer(outputfile* out)
{
	line_header(out);
	out->write ("<a name=\"skill\">Skill is calculated as (kills / (total deaths + 1))</a>");
	out->write ("<br><a name=\"mkiol\">MKIOL means \"Most Kills In One Life\"</a>");
	line_footer(out);
	line_header(out);
	out->write ("<font size=\"2\"><a href=\"http://www.planetquake.com/idda/\">");
	out->write ("<font color=\"#FF0000\">Q3LA</font></a> %s, %s", version, date);
	out->write (" by <a href=\"mailto:spike@planetquake.com\">");
	out->write ("<font color=\"#FFFFFF\">Fabian Huester</font></font>");
	line_footer(out);
	out->write ("</font>");
	out->write ("</body>\r\n");
	out->write ("</center>\r\n");
	out->write ("</html>\r\n");
}

void html::table_header(outputfile* out, char* formatstring)
{
	out->write ("\r\n<table %s>\r\n", formatstring);
}

void html::table_footer(outputfile* out)
{
	out->write ("</table>\r\n");
}

void html::table_entry(outputfile* out, char* formatstring, ...)
{
	va_list arglist;
	static char tempstr[256];
	va_start (arglist, formatstring);
	vsprintf (tempstr, formatstring, arglist);
	out->write ("%s%s</td>\r\n", td_string, tempstr);
}

void html::table_entry_bold(outputfile* out, char* formatstring, ...)
{
	va_list arglist;
	static char tempstr[256];
	va_start (arglist, formatstring);
	vsprintf (tempstr, formatstring, arglist);
	out->write ("%s<b>%s</b></td>\r\n", td_string, tempstr);
}

void html::line(outputfile* out, char* formatstring, ...)
{
	va_list arglist;
	char tempstr[256];
	va_start (arglist, formatstring);
	vsprintf (tempstr, formatstring, arglist);

	line_header(out);
	out->write ("%s", tempstr);
	line_footer(out);
}

void html::line_header(outputfile* out)
{
	out->write ("<p>");
}

void html::line_footer(outputfile* out)
{
	out->write ("</p>");
}

void html::set_td(char* td_in)
{
	strcpy (td_string, td_in);
}
